import importlib
import warnings
from typing import List


def import_module(modules: List[str]) -> None:
    """
    Overview:
        Import several module as a list
    Args:
        - modules (:obj:`list` of `str`): List of module names
    """
    for name in modules:
        importlib.import_module(name)


MODULE_PATHS = {
    'Agent': 'agent'
}


def import_pipeline_module(pipeline, name='Agent'):
    try:
        abs_path = f'pipelines.{pipeline}.{MODULE_PATHS[name]}'
        module = importlib.import_module(abs_path)
        module = getattr(module, name)
        return module
    except Exception as e:
        import traceback
        print(f'[Import Error]{e}', flush=True)
        print(''.join(traceback.format_tb(e.__traceback__)), flush=True)
        raise TypeError




if __name__ == '__main__':
    pass